/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ChampionOfLambholtEffect
extends RestrictionEffect {
    ChampionOfLambholtEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures with power less than {this}'s power can't block creatures you control";
    }

    private ChampionOfLambholtEffect(ChampionOfLambholtEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return true;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null && attacker != null && attacker.isControlledBy(sourcePermanent.getControllerId())) {
            return blocker.getPower().getValue() >= sourcePermanent.getPower().getValue();
        }
        return true;
    }

    public ChampionOfLambholtEffect copy() {
        return new ChampionOfLambholtEffect(this);
    }
}

