/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChandraAblazeDamageEffect
extends OneShotEffect {
    public ChandraAblazeDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "If a red card is discarded this way, {this} deals 4 damage to any target";
    }

    private ChandraAblazeDamageEffect(ChandraAblazeDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraAblazeDamageEffect copy() {
        return new ChandraAblazeDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = (Card)this.getValue("discardedCard");
        if (card != null && card.getColor(game).isRed()) {
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                permanent.damage(4, source.getSourceId(), source, game, false, true);
                return true;
            }
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (player != null) {
                player.damage(4, source.getSourceId(), source, game);
                return true;
            }
        }
        return false;
    }
}

