/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.RedElementalToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChandraAcolyteOfFlameEffect
extends OneShotEffect {
    ChandraAcolyteOfFlameEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create two 1/1 red Elemental creature tokens. They gain haste. Sacrifice them at the beginning of the next end step.";
    }

    private ChandraAcolyteOfFlameEffect(ChandraAcolyteOfFlameEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraAcolyteOfFlameEffect copy() {
        return new ChandraAcolyteOfFlameEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        RedElementalToken token = new RedElementalToken();
        token.putOntoBattlefield(2, game, source, source.getControllerId());
        token.getLastAddedTokenIds().stream().forEach(permId -> {
            Permanent permanent = game.getPermanent(permId);
            if (permanent == null) {
                return;
            }
            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permId, game));
            game.addEffect((ContinuousEffect)effect, source);
            SacrificeTargetEffect effect2 = new SacrificeTargetEffect();
            effect2.setTargetPointer((TargetPointer)new FixedTarget(permId, game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect2), source);
            InfoEffect.addInfoToPermanent((Game)game, (Ability)source, (Permanent)permanent, (String)"<i><b>Warning</b>: It will be sacrificed at the beginning of the next end step</i>");
        });
        return true;
    }
}

