/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ChandraDressedToKillExile1Effect
extends OneShotEffect {
    ChandraDressedToKillExile1Effect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top card of your library. If it's red, you may cast it this turn";
    }

    private ChandraDressedToKillExile1Effect(ChandraDressedToKillExile1Effect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraDressedToKillExile1Effect copy() {
        return new ChandraDressedToKillExile1Effect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        MageObject sourceObject = source.getSourceObject(game);
        String exileName = sourceObject == null ? null : sourceObject.getIdName();
        controller.moveCardsToExile(card, source, game, true, exileId, exileName);
        if (game.getState().getZone(card.getId()) == Zone.EXILED && card.getColor(game).isRed()) {
            game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.EndOfTurn, false, true).setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        }
        return true;
    }
}

