/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.ChandraDressedToKillPlayEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ChandraDressedToKillExile5Effect
extends OneShotEffect {
    ChandraDressedToKillExile5Effect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top five cards of your library. You may cast red spells from among them this turn";
    }

    private ChandraDressedToKillExile5Effect(ChandraDressedToKillExile5Effect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraDressedToKillExile5Effect copy() {
        return new ChandraDressedToKillExile5Effect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set cards = controller.getLibrary().getTopCards(game, 5);
        if (cards.isEmpty()) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        MageObject sourceObject = source.getSourceObject(game);
        String exileName = sourceObject == null ? null : sourceObject.getIdName();
        controller.moveCardsToExile(cards, source, game, true, exileId, exileName);
        cards.removeIf(card -> !Zone.EXILED.equals((Object)game.getState().getZone(card.getId())));
        if (!cards.isEmpty()) {
            game.addEffect(new ChandraDressedToKillPlayEffect().setTargetPointer((TargetPointer)new FixedTargets((Collection)cards, game)), source);
        }
        return true;
    }
}

