/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChandraFireArtisanEffect
extends OneShotEffect {
    private final boolean exileSeven;

    ChandraFireArtisanEffect(boolean exileSeven) {
        super(Outcome.Detriment);
        this.exileSeven = exileSeven;
        this.staticText = exileSeven ? "Exile the top seven cards of your library. You may play them this turn." : "Exile the top card of your library. You may play it this turn";
    }

    private ChandraFireArtisanEffect(ChandraFireArtisanEffect effect) {
        super((OneShotEffect)effect);
        this.exileSeven = effect.exileSeven;
    }

    public ChandraFireArtisanEffect copy() {
        return new ChandraFireArtisanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, this.exileSeven ? 7 : 1));
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Card card : cards.getCards(game)) {
            if (card == null) continue;
            PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

