/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.c.ChandraHopesBeaconPlayEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ChandraHopesBeaconEffect
extends OneShotEffect {
    ChandraHopesBeaconEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top five cards of your library. Until the end of your next turn, you may cast an instant or sorcery spell from among those exiled cards";
    }

    private ChandraHopesBeaconEffect(ChandraHopesBeaconEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraHopesBeaconEffect copy() {
        return new ChandraHopesBeaconEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 5));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        CardsImpl instantsOrSorceries = new CardsImpl((Collection)cards.stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(card -> card.isInstantOrSorcery(game)).map(MageItem::getId).collect(Collectors.toSet()));
        game.addEffect((ContinuousEffect)new ChandraHopesBeaconPlayEffect((Cards)instantsOrSorceries, game), source);
        return true;
    }
}

