/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChandrasIgnitionEffect
extends OneShotEffect {
    ChandrasIgnitionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature you control deals damage equal to its power to each other creature and each opponent";
    }

    private ChandrasIgnitionEffect(ChandrasIgnitionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandrasIgnitionEffect copy() {
        return new ChandrasIgnitionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null && targetCreature.getPower().getValue() > 0) {
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                if (creature.getId().equals(targetCreature.getId())) continue;
                creature.damage(targetCreature.getPower().getValue(), targetCreature.getId(), source, game, false, true);
            }
            for (UUID opponentId : game.getOpponents(source.getControllerId())) {
                Player opponent = game.getPlayer(opponentId);
                if (opponent == null) continue;
                opponent.damage(targetCreature.getPower().getValue(), targetCreature.getId(), source, game);
            }
        }
        return true;
    }
}

