/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChandrasRevolutionEffect
extends OneShotEffect {
    ChandrasRevolutionEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 4 damage to target creature. Tap target land. That land doesn't untap during its controller's next untap step";
    }

    private ChandrasRevolutionEffect(ChandrasRevolutionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandrasRevolutionEffect copy() {
        return new ChandrasRevolutionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean applied = false;
        Permanent permanent = game.getPermanent(((Target)source.getTargets().get(0)).getFirstTarget());
        if (permanent != null) {
            applied |= permanent.damage(4, source.getSourceId(), source, game, false, true) > 0;
        }
        if ((permanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            permanent.tap(source, game);
            DontUntapInControllersNextUntapStepTargetEffect effect = new DontUntapInControllersNextUntapStepTargetEffect("that land");
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return applied;
    }
}

