/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class ChangeOfPlansEffect
extends OneShotEffect {
    ChangeOfPlansEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may have any number of them phase out";
    }

    private ChangeOfPlansEffect(ChangeOfPlansEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChangeOfPlansEffect copy() {
        return new ChangeOfPlansEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Set permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanentOrLKIBattlefield(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (permanents.isEmpty()) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return true;
        }
        FilterPermanent filter = new FilterPermanent("creatures");
        filter.add((Predicate)new PermanentReferenceInCollectionPredicate(permanents, game));
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, target.withChooseHint("to phase out"), source, game);
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.phaseOut(game);
        }
        return true;
    }
}

