/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.RandomUtil;

class ChaosDefilerEffect
extends OneShotEffect {
    ChaosDefilerEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each opponent, choose a nonland permanent that player controls. Destroy one of them chosen at random";
    }

    private ChaosDefilerEffect(ChaosDefilerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChaosDefilerEffect copy() {
        return new ChaosDefilerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        HashSet<Permanent> permanents = new HashSet<Permanent>();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent;
            if (!game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_NON_LAND, opponentId, source, game, 1) || (opponent = game.getPlayer(opponentId)) == null) continue;
            FilterNonlandPermanent filter = new FilterNonlandPermanent("nonland permanent controlled by " + opponent.getName());
            filter.add((Predicate)new ControllerIdPredicate(opponentId));
            TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
            player.choose(this.outcome, (Target)target, source, game);
            permanents.add(game.getPermanent(target.getFirstTarget()));
        }
        permanents.removeIf(Objects::isNull);
        Permanent permanent = (Permanent)RandomUtil.randomFromCollection(permanents);
        return permanent != null && permanent.destroy(source, game);
    }
}

