/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ChaosDragonRestrictionEffect
extends RestrictionEffect {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    public ChaosDragonRestrictionEffect(Set<UUID> playerSet) {
        super(Duration.EndOfCombat, Outcome.Benefit);
        this.playerSet.addAll(playerSet);
    }

    private ChaosDragonRestrictionEffect(ChaosDragonRestrictionEffect effect) {
        super((RestrictionEffect)effect);
        this.playerSet.addAll(effect.playerSet);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.equals(source.getSourcePermanentIfItStillExists(game));
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (this.playerSet.contains(defenderId)) {
            return false;
        }
        Permanent planeswalker = game.getPermanent(defenderId);
        return planeswalker == null || !this.playerSet.contains(planeswalker.getControllerId());
    }

    public ChaosDragonRestrictionEffect copy() {
        return new ChaosDragonRestrictionEffect(this);
    }
}

