/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class ChargingTuskodonEffect
extends ReplacementEffectImpl {
    ChargingTuskodonEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If {this} would deal combat damage to a player, it deals double that damage to that player instead";
    }

    private ChargingTuskodonEffect(ChargingTuskodonEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ChargingTuskodonEffect copy() {
        return new ChargingTuskodonEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getSourceId().equals(event.getSourceId()) && ((DamageEvent)event).isCombatDamage();
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

