/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.MillCardsCost;
import mage.abilities.costs.mana.ColoredManaCost;
import mage.abilities.costs.mana.ColorlessHybridManaCost;
import mage.abilities.costs.mana.ColorlessManaCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.costs.mana.MonoHybridManaCost;
import mage.abilities.costs.mana.VariableManaCost;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.ManaOptions;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.game.Game;
import mage.players.Player;

class CharmedPendantManaEffect
extends ManaEffect {
    CharmedPendantManaEffect() {
        this.staticText = "For each colored mana symbol in the milled card's mana cost, add one mana of that color";
    }

    private CharmedPendantManaEffect(CharmedPendantManaEffect effect) {
        super((ManaEffect)effect);
    }

    public CharmedPendantManaEffect copy() {
        return new CharmedPendantManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        Card card;
        if (game == null) {
            return new ArrayList<Mana>();
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.isTopCardRevealed() && (card = controller.getLibrary().getFromTop(game)) != null) {
            List netMana = card.getManaCost().getManaOptions();
            for (Mana mana : netMana) {
                mana.setColorless(0);
                mana.setGeneric(0);
            }
            return netMana;
        }
        return new ArrayList<Mana>();
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            block0: for (Cost cost : source.getCosts()) {
                Card card;
                Set cards;
                if (!(cost instanceof MillCardsCost) || (cards = ((MillCardsCost)cost).getCardsMovedToGraveyard()).isEmpty() || (card = (Card)cards.iterator().next()) == null || card.getManaCost() == null) continue;
                ManaCostsImpl newManaCosts = new ManaCostsImpl();
                for (ManaCost manaCost : card.getManaCost()) {
                    if (manaCost instanceof ColorlessManaCost || manaCost instanceof GenericManaCost || manaCost instanceof VariableManaCost) continue;
                    if (manaCost instanceof MonoHybridManaCost) {
                        newManaCosts.add((Object)new ColoredManaCost(((MonoHybridManaCost)manaCost).getManaColor()));
                        continue;
                    }
                    if (manaCost instanceof ColorlessHybridManaCost) {
                        newManaCosts.add((Object)new ColoredManaCost(((ColorlessHybridManaCost)manaCost).getManaColor()));
                        continue;
                    }
                    newManaCosts.add((Object)manaCost.copy());
                }
                ManaOptions manaOptions = newManaCosts.getOptions();
                if (manaOptions.size() == 1) {
                    mana = newManaCosts.getMana();
                    continue;
                }
                ChoiceImpl manaChoice = new ChoiceImpl(true);
                manaChoice.setMessage("Select which mana you like to produce");
                for (Mana manaOption : manaOptions) {
                    manaChoice.getChoices().add(manaOption.toString());
                }
                if (manaChoice.getChoices().isEmpty()) {
                    return mana;
                }
                if (!controller.choose(this.outcome, (Choice)manaChoice, game)) continue;
                for (Mana manaOption : manaOptions) {
                    if (!manaChoice.getChoice().equals(manaOption.toString())) continue;
                    mana = manaOption;
                    continue block0;
                }
            }
        }
        return mana;
    }
}

