/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.SquirrelToken;

class ChatterfangSquirrelGeneralReplacementEffect
extends ReplacementEffectImpl {
    ChatterfangSquirrelGeneralReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If one or more tokens would be created under your control, those tokens plus that many 1/1 green Squirrel creature tokens are created instead";
    }

    private ChatterfangSquirrelGeneralReplacementEffect(ChatterfangSquirrelGeneralReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ChatterfangSquirrelGeneralReplacementEffect copy() {
        return new ChatterfangSquirrelGeneralReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (event instanceof CreateTokenEvent) {
            CreateTokenEvent tokenEvent = (CreateTokenEvent)event;
            SquirrelToken squirrelToken = null;
            int amount = 0;
            Map tokens = tokenEvent.getTokens();
            for (Map.Entry entry : tokens.entrySet()) {
                amount += ((Integer)entry.getValue()).intValue();
                if (!(entry.getKey() instanceof SquirrelToken)) continue;
                squirrelToken = (SquirrelToken)entry.getKey();
            }
            if (squirrelToken == null) {
                squirrelToken = new SquirrelToken();
            }
            tokens.put(squirrelToken, tokens.getOrDefault(squirrelToken, 0) + amount);
        }
        return false;
    }
}

