/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageInt;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.BecomesMonstrousSourceTriggeredAbility;
import mage.abilities.common.DiesCreatureTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.MonstrosityAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.permanent.token.EwokToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ChiefChirpa
extends CardImpl {
    private static final FilterCreaturePermanent diedFilter = new FilterCreaturePermanent("a green creature you control");
    private static final FilterControlledCreaturePermanent ewokFilter = new FilterControlledCreaturePermanent("another target Ewok creature you control");

    public ChiefChirpa(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{R}{G}{W}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.EWOK);
        this.subtype.add((Object)SubType.WARRIOR);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);
        this.addAbility((Ability)new MonstrosityAbility("{2}{R}{G}{W}", 2));
        DiesCreatureTriggeredAbility ability = new DiesCreatureTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), true, (FilterPermanent)diedFilter);
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)ewokFilter));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new BecomesMonstrousSourceTriggeredAbility((Effect)new CreateTokenEffect((Token)new EwokToken(), 3)));
    }

    private ChiefChirpa(ChiefChirpa card) {
        super((CardImpl)card);
    }

    public ChiefChirpa copy() {
        return new ChiefChirpa(this);
    }

    static {
        diedFilter.add((Predicate)new ColorPredicate(ObjectColor.GREEN));
        diedFilter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        ewokFilter.add((Predicate)SubType.EWOK.getPredicate());
        ewokFilter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

