/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class ChimericStaffEffect
extends ContinuousEffectImpl {
    ChimericStaffEffect() {
        super(Duration.EndOfTurn, Outcome.BecomeCreature);
        this.staticText = "{this} becomes an X/X Construct artifact creature until end of turn";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private ChimericStaffEffect(ChimericStaffEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ChimericStaffEffect copy() {
        return new ChimericStaffEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                if (!permanent.isArtifact(game)) {
                    permanent.addCardType(game, new CardType[]{CardType.ARTIFACT});
                }
                if (!permanent.isCreature(game)) {
                    permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                }
                permanent.removeAllCreatureTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.CONSTRUCT});
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
                permanent.getPower().setModifiedBaseValue(xValue);
                permanent.getToughness().setModifiedBaseValue(xValue);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.TypeChangingEffects_4;
    }
}

