/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

class ChooseCreatureTypeEffect
extends OneShotEffect {
    ChooseCreatureTypeEffect(Outcome outcome) {
        super(outcome);
        this.staticText = "choose a creature type";
    }

    private ChooseCreatureTypeEffect(ChooseCreatureTypeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getObject(source);
        ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
        if (controller != null && mageObject != null && controller.choose(this.outcome, (Choice)typeChoice, game)) {
            if (!game.isSimulation()) {
                game.informPlayers(mageObject.getName() + ": " + controller.getLogName() + " has chosen " + typeChoice.getChoiceKey());
            }
            game.getState().setValue(mageObject.getId() + "_type", (Object)SubType.byDescription((String)typeChoice.getChoiceKey()));
            return true;
        }
        return false;
    }

    public ChooseCreatureTypeEffect copy() {
        return new ChooseCreatureTypeEffect(this);
    }
}

