/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Map;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ChorusOfTheConclaveReplacementEffect2
extends ReplacementEffectImpl {
    public ChorusOfTheConclaveReplacementEffect2() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you do, that creature enters the battlefield with that many additional +1/+1 counters on it";
    }

    private ChorusOfTheConclaveReplacementEffect2(ChorusOfTheConclaveReplacementEffect2 effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ChorusOfTheConclaveReplacementEffect2 copy() {
        return new ChorusOfTheConclaveReplacementEffect2(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Map spellX = (Map)game.getState().getValue("spellX" + source.getSourceId());
        return spellX != null && event.getSourceId() != null && spellX.containsKey(event.getSourceId().toString() + (game.getState().getZoneChangeCounter(event.getSourceId()) - 1));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        Map spellX = (Map)game.getState().getValue("spellX" + source.getSourceId());
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null && creature != null && spellX != null) {
            String key = event.getSourceId().toString() + (game.getState().getZoneChangeCounter(event.getSourceId()) - 1);
            int xValue = (Integer)spellX.get(key);
            if (xValue > 0) {
                creature.addCounters(CounterType.P1P1.createInstance(xValue), source.getControllerId(), source, game, event.getAppliedEffects());
                game.informPlayers(sourceObject.getLogName() + ": " + creature.getLogName() + " enters the battlefield with " + xValue + " +1/+1 counter" + (xValue > 1 ? "s" : "") + " on it");
            }
            spellX.remove(key);
        }
        return false;
    }
}

