/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChromeMoxManaEffect
extends ManaEffect {
    ChromeMoxManaEffect() {
        this.staticText = "Add one mana of any of the exiled card's colors";
    }

    private ChromeMoxManaEffect(ChromeMoxManaEffect effect) {
        super((ManaEffect)effect);
    }

    public ChromeMoxManaEffect copy() {
        return new ChromeMoxManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        Card imprintedCard;
        List imprinted;
        Permanent permanent;
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game != null && (permanent = game.getPermanent(source.getSourceId())) != null && (imprinted = permanent.getImprinted()) != null && !imprinted.isEmpty() && (imprintedCard = game.getCard((UUID)imprinted.get(0))) != null) {
            ObjectColor color = imprintedCard.getColor(game);
            if (color.isBlack()) {
                netMana.add(Mana.BlackMana((int)1));
            }
            if (color.isRed()) {
                netMana.add(Mana.RedMana((int)1));
            }
            if (color.isBlue()) {
                netMana.add(Mana.BlueMana((int)1));
            }
            if (color.isGreen()) {
                netMana.add(Mana.GreenMana((int)1));
            }
            if (color.isWhite()) {
                netMana.add(Mana.WhiteMana((int)1));
            }
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        Card imprintedCard;
        List imprinted;
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        if (permanent != null && player != null && (imprinted = permanent.getImprinted()) != null && !imprinted.isEmpty() && (imprintedCard = game.getCard((UUID)imprinted.get(0))) != null) {
            ChoiceColor choice = new ChoiceColor(true);
            choice.getChoices().clear();
            choice.setMessage("Pick a mana color");
            ObjectColor color = imprintedCard.getColor(game);
            if (color.isBlack()) {
                choice.getChoices().add("Black");
            }
            if (color.isRed()) {
                choice.getChoices().add("Red");
            }
            if (color.isBlue()) {
                choice.getChoices().add("Blue");
            }
            if (color.isGreen()) {
                choice.getChoices().add("Green");
            }
            if (color.isWhite()) {
                choice.getChoices().add("White");
            }
            if (!choice.getChoices().isEmpty()) {
                if (choice.getChoices().size() == 1) {
                    choice.setChoice((String)choice.getChoices().iterator().next());
                } else if (!player.choose(Outcome.PutManaInPool, (Choice)choice, game)) {
                    return mana;
                }
                switch (choice.getChoice()) {
                    case "Black": {
                        mana.add(Mana.BlackMana((int)1));
                        break;
                    }
                    case "Blue": {
                        mana.add(Mana.BlueMana((int)1));
                        break;
                    }
                    case "Red": {
                        mana.add(Mana.RedMana((int)1));
                        break;
                    }
                    case "Green": {
                        mana.add(Mana.GreenMana((int)1));
                        break;
                    }
                    case "White": {
                        mana.add(Mana.WhiteMana((int)1));
                        break;
                    }
                }
            }
        }
        return mana;
    }
}

