/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class ChurningReservoirWatcher
extends Watcher {
    private final Set<UUID> set = new HashSet<UUID>();

    ChurningReservoirWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case ZONE_CHANGE: {
                ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
                if (zEvent.isDiesEvent() && zEvent.getTarget().getCounters(game).containsKey(CounterType.OIL)) {
                    this.set.add(zEvent.getTarget().getControllerId());
                }
                return;
            }
            case COUNTER_REMOVED: {
                if (!event.getData().equals(CounterType.OIL.getName())) break;
                this.condition = true;
            }
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPlayer(Ability source, Game game) {
        ChurningReservoirWatcher watcher = (ChurningReservoirWatcher)game.getState().getWatcher(ChurningReservoirWatcher.class);
        return watcher.condition || watcher.set.contains(source.getControllerId());
    }
}

