/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class CircleOfConfinementTriggeredAbility
extends TriggeredAbilityImpl {
    public CircleOfConfinementTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainLifeEffect(2));
        this.setTriggerPhrase("Whenever an opponent casts a Vampire spell with the same name as a card exiled with {this}, ");
    }

    private CircleOfConfinementTriggeredAbility(CircleOfConfinementTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CircleOfConfinementTriggeredAbility copy() {
        return new CircleOfConfinementTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ExileZone exileZone;
        Spell spell;
        if (game.getOpponents(this.controllerId).contains(event.getPlayerId()) && (spell = game.getSpell(event.getTargetId())) != null && spell.hasSubtype(SubType.VAMPIRE, game) && (exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)this.sourceId, (int)game.getState().getZoneChangeCounter(this.sourceId)))) != null) {
            for (UUID cardId : exileZone) {
                if (!CardUtil.haveSameNames((MageObject)spell, (MageObject)game.getCard(cardId))) continue;
                return true;
            }
        }
        return false;
    }
}

