/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class CircuDimirLobotomistEffect
extends OneShotEffect {
    CircuDimirLobotomistEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile the top card of target player's library";
    }

    private CircuDimirLobotomistEffect(CircuDimirLobotomistEffect effect) {
        super((OneShotEffect)effect);
    }

    public CircuDimirLobotomistEffect copy() {
        return new CircuDimirLobotomistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player playerTargetLibrary = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || playerTargetLibrary == null) {
            return false;
        }
        controller.moveCardsToExile(playerTargetLibrary.getLibrary().getFromTop(game), source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        return true;
    }
}

