/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class CircuDimirLobotomistRuleModifyingEffect
extends ContinuousRuleModifyingEffectImpl {
    CircuDimirLobotomistRuleModifyingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Your opponents can't cast spells with the same name as a card exiled with {this}";
    }

    private CircuDimirLobotomistRuleModifyingEffect(CircuDimirLobotomistRuleModifyingEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public CircuDimirLobotomistRuleModifyingEffect copy() {
        return new CircuDimirLobotomistRuleModifyingEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        return "You can't cast this spell because a card with the same name is exiled by " + CardUtil.getSourceName((Game)game, (Ability)source) + '.';
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        MageObject object = game.getObject(event.getSourceId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getCardExileZoneId((Game)game, (Ability)source));
        return object != null && exileZone != null && !exileZone.isEmpty() && exileZone.getCards(game).stream().anyMatch(card -> CardUtil.haveSameNames((MageObject)card, (MageObject)object));
    }
}

