/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.ClownRobotToken;
import mage.players.Player;

class CircuitsActEffect
extends OneShotEffect {
    CircuitsActEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll three six-sided dice. For each different result, create a 1/1 white Clown Robot artifact creature token";
    }

    private CircuitsActEffect(CircuitsActEffect effect) {
        super((OneShotEffect)effect);
    }

    public CircuitsActEffect copy() {
        return new CircuitsActEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int count = player.rollDice(this.outcome, source, game, 6, 3, 0).stream().distinct().mapToInt(x -> 1).sum();
        if (count > 0) {
            new ClownRobotToken().putOntoBattlefield(count, game, source);
        }
        return true;
    }
}

