/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class CityOnFireEffect
extends ReplacementEffectImpl {
    CityOnFireEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a source you control would deal damage to a permanent or player, it deals triple that damage instead";
    }

    private CityOnFireEffect(CityOnFireEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public CityOnFireEffect copy() {
        return new CityOnFireEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType().equals((Object)GameEvent.EventType.DAMAGE_PLAYER) || event.getType().equals((Object)GameEvent.EventType.DAMAGE_PERMANENT);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getControllerId(event.getSourceId()).equals(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)3));
        return false;
    }
}

