/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CivilizedScholarEffect
extends OneShotEffect {
    CivilizedScholarEffect() {
        super(Outcome.DrawCard);
        this.staticText = ", then discard a card. If a creature card is discarded this way, untap {this}, then transform it";
    }

    private CivilizedScholarEffect(CivilizedScholarEffect effect) {
        super((OneShotEffect)effect);
    }

    public CivilizedScholarEffect copy() {
        return new CivilizedScholarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.discardOne(false, false, source, game);
        if (card == null || !card.isCreature(game)) {
            return true;
        }
        Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(permanent -> {
            permanent.untap(game);
            permanent.transform(source, game);
        });
        return true;
    }
}

