/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ClarionConquerorEffect
extends RestrictionEffect {
    ClarionConquerorEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "activated abilities of artifacts, creatures, and planeswalkers can't be activated";
    }

    private ClarionConquerorEffect(ClarionConquerorEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isArtifact(game) || permanent.isCreature(game) || permanent.isPlaneswalker(game);
    }

    public boolean canUseActivatedAbilities(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public ClarionConquerorEffect copy() {
        return new ClarionConquerorEffect(this);
    }
}

