/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.decorator.ConditionalRestrictionEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.abilities.effects.common.combat.CantBlockAttachedEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ClawingTorment
extends CardImpl {
    private static final Condition condition = new AttachedToMatchesFilterCondition((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);

    public ClawingTorment(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{B}");
        this.subtype.add((Object)SubType.AURA);
        TargetPermanent auraTarget = new TargetPermanent(StaticFilters.FILTER_PERMANENT_ARTIFACT_OR_CREATURE);
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.UnboostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new ConditionalContinuousEffect((ContinuousEffect)new BoostEnchantedEffect(-1, -1), condition, "as long as enchanted permanent is a creature, it gets -1/-1"));
        ability.addEffect((Effect)new ConditionalRestrictionEffect((RestrictionEffect)new CantBlockAttachedEffect(AttachmentType.AURA), condition, "and can't block"));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityAttachedEffect((Ability)new BeginningOfUpkeepTriggeredAbility((Effect)new LoseLifeSourceControllerEffect(1), false), AttachmentType.AURA, Duration.WhileOnBattlefield, "enchanted permanent has \"At the beginning of your upkeep, you lose 1 life.\"")));
    }

    private ClawingTorment(ClawingTorment card) {
        super((CardImpl)card);
    }

    public ClawingTorment copy() {
        return new ClawingTorment(this);
    }
}

