/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ClingToDustEffect
extends OneShotEffect {
    ClingToDustEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target card from a graveyard. If it was a creature card, you gain 3 life. Otherwise, you draw a card";
    }

    private ClingToDustEffect(ClingToDustEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClingToDustEffect copy() {
        return new ClingToDustEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        boolean isCreature = card.isCreature(game);
        if (!player.moveCards(card, Zone.EXILED, source, game)) {
            return false;
        }
        if (isCreature) {
            player.gainLife(3, game, source);
        } else {
            player.drawCards(1, source, game);
        }
        return true;
    }
}

