/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CloakOfConfusionEffect
extends ReplacementEffectImpl {
    CloakOfConfusionEffect() {
        super(Duration.EndOfTurn, Outcome.Neutral);
    }

    private CloakOfConfusionEffect(CloakOfConfusionEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public CloakOfConfusionEffect copy() {
        return new CloakOfConfusionEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!((DamageEvent)event).isCombatDamage()) {
            return false;
        }
        Permanent aura = source.getSourcePermanentOrLKI(game);
        return aura != null && event.getSourceId().equals(aura.getAttachedTo());
    }
}

