/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CloakedCadetTriggeredAbility
extends TriggeredAbilityImpl {
    CloakedCadetTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.setTriggersLimitEachTurn(1);
        this.setTriggerPhrase("Whenever one or more +1/+1 counters are put on one or more Humans you control, ");
    }

    private CloakedCadetTriggeredAbility(CloakedCadetTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CloakedCadetTriggeredAbility copy() {
        return new CloakedCadetTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null) {
            permanent = game.getPermanentEntering(event.getTargetId());
        }
        return permanent != null && this.isControlledBy(permanent.getControllerId()) && permanent.hasSubtype(SubType.HUMAN, game) && event.getData().equals(CounterType.P1P1.getName());
    }
}

