/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.RemoveCounterTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ClockworkBeetleEffect
extends OneShotEffect {
    ClockworkBeetleEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "remove a +1/+1 counter from {this} at end of combat";
    }

    private ClockworkBeetleEffect(ClockworkBeetleEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            RemoveCounterTargetEffect effect = new RemoveCounterTargetEffect(CounterType.P1P1.createInstance());
            effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), source.getStackMomentSourceZCC()));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheEndOfCombatDelayedTriggeredAbility((Effect)effect), source);
            return true;
        }
        return false;
    }

    public ClockworkBeetleEffect copy() {
        return new ClockworkBeetleEffect(this);
    }
}

