/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.predicate.permanent.EquippedPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class CloudMidgarMercenaryEffect
extends ReplacementEffectImpl {
    CloudMidgarMercenaryEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "as long as {this} is equipped, if an ability of {this} or an Equipment attached to it triggers, that ability triggers an additional time";
    }

    private CloudMidgarMercenaryEffect(CloudMidgarMercenaryEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public CloudMidgarMercenaryEffect copy() {
        return new CloudMidgarMercenaryEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent == null || !EquippedPredicate.instance.apply(sourcePermanent, game)) {
            return false;
        }
        NumberOfTriggersEvent numberOfTriggersEvent = (NumberOfTriggersEvent)event;
        GameEvent sourceEvent = numberOfTriggersEvent.getSourceEvent();
        if (sourceEvent == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(((NumberOfTriggersEvent)event).getSourceId());
        return permanent != null && (permanent.equals(sourcePermanent) || permanent.hasSubtype(SubType.EQUIPMENT, game) && sourcePermanent.getAttachments().contains(permanent.getId()));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }
}

