/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class CloudstoneCurioEffect
extends OneShotEffect {
    CloudstoneCurioEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "you may return another permanent you control that shares a permanent type with it to its owner's hand";
    }

    private CloudstoneCurioEffect(CloudstoneCurioEffect effect) {
        super((OneShotEffect)effect);
    }

    public CloudstoneCurioEffect copy() {
        return new CloudstoneCurioEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent triggeringCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
            if (triggeringCreature != null) {
                Permanent returningCreature;
                FilterPermanent filter = new FilterPermanent("another permanent you control that shares a permanent type with " + triggeringCreature.getName());
                filter.add(Predicates.not((Predicate)new PermanentIdPredicate(triggeringCreature.getId())));
                filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
                filter.add(Predicates.or((Iterable)triggeringCreature.getCardType(game).stream().filter(CardType::isPermanentType).map(CardType::getPredicate).collect(Collectors.toSet())));
                TargetPermanent target = new TargetPermanent(1, 1, filter, true);
                if (target.canChoose(controller.getId(), source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game) && (returningCreature = game.getPermanent(target.getFirstTarget())) != null) {
                    controller.moveCards((Card)returningCreature, Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

