/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.c.CodieVociferousCodexEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class CodieVociferousCodexDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    CodieVociferousCodexDelayedTriggeredAbility() {
        super((Effect)new CodieVociferousCodexEffect(), Duration.EndOfTurn, true, false);
    }

    private CodieVociferousCodexDelayedTriggeredAbility(CodieVociferousCodexDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null) {
            return false;
        }
        this.getEffects().setValue("spellCast", (Object)spell);
        return true;
    }

    public CodieVociferousCodexDelayedTriggeredAbility copy() {
        return new CodieVociferousCodexDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "When you next cast a spell this turn, exile cards from the top of your library until you exile an instant or sorcery card with lesser mana value. Until end of turn, you may cast that card without paying its mana cost. Put each other card exiled this way on the bottom of your library in a random order.";
    }
}

