/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CodieVociferousCodexEffect
extends OneShotEffect {
    CodieVociferousCodexEffect() {
        super(Outcome.Benefit);
    }

    private CodieVociferousCodexEffect(CodieVociferousCodexEffect effect) {
        super((OneShotEffect)effect);
    }

    public CodieVociferousCodexEffect copy() {
        return new CodieVociferousCodexEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (controller == null || spell == null) {
            return false;
        }
        CardsImpl toExile = new CardsImpl();
        Card toCast = null;
        for (Card card : controller.getLibrary().getCards(game)) {
            toExile.add(card);
            if (!card.isInstantOrSorcery(game) || card.getManaValue() >= spell.getManaValue()) continue;
            toCast = card;
            break;
        }
        if (toCast == null) {
            controller.moveCards((Cards)toExile, Zone.EXILED, source, game);
            controller.putCardsOnBottomOfLibrary((Cards)toExile, game, source, false);
            return true;
        }
        controller.moveCards(toCast, Zone.EXILED, source, game);
        PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.EndOfTurn, true);
        effect.setTargetPointer((TargetPointer)new FixedTarget(toCast.getId(), game));
        game.addEffect((ContinuousEffect)effect, source);
        toExile.remove(toCast);
        controller.putCardsOnBottomOfLibrary((Cards)toExile, game, source, false);
        return true;
    }
}

