/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.CoffinQueenDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CoffinQueenCreateDelayedTriggerEffect
extends OneShotEffect {
    CoffinQueenCreateDelayedTriggerEffect() {
        super(Outcome.Detriment);
        this.staticText = "When {this} becomes untapped or you lose control of {this}, exile that creature.";
    }

    private CoffinQueenCreateDelayedTriggerEffect(CoffinQueenCreateDelayedTriggerEffect effect) {
        super((OneShotEffect)effect);
    }

    public CoffinQueenCreateDelayedTriggerEffect copy() {
        return new CoffinQueenCreateDelayedTriggerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent controlledCreature = game.getPermanent(source.getFirstTarget());
        if (controlledCreature != null) {
            CoffinQueenDelayedTriggeredAbility delayedAbility = new CoffinQueenDelayedTriggeredAbility();
            ((Effect)delayedAbility.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(controlledCreature, game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            return true;
        }
        return false;
    }
}

