/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class CoffinQueenDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    CoffinQueenDelayedTriggeredAbility() {
        super((Effect)new ExileTargetEffect(), Duration.EndOfGame, true);
    }

    private CoffinQueenDelayedTriggeredAbility(CoffinQueenDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOST_CONTROL || event.getType() == GameEvent.EventType.UNTAPPED || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (GameEvent.EventType.LOST_CONTROL == event.getType() && event.getTargetId().equals(this.getSourceId())) {
            return true;
        }
        if (GameEvent.EventType.UNTAPPED == event.getType() && event.getTargetId() != null && event.getTargetId().equals(this.getSourceId())) {
            return true;
        }
        return GameEvent.EventType.ZONE_CHANGE == event.getType() && event.getTargetId().equals(this.getSourceId());
    }

    public CoffinQueenDelayedTriggeredAbility copy() {
        return new CoffinQueenDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "When {this} becomes untapped or you lose control of {this}, exile that creature.";
    }
}

