/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.DefenderAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;

class CoilsOfTheMedusaDestroyEffect
extends OneShotEffect {
    public CoilsOfTheMedusaDestroyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all non-Wall creatures blocking enchanted creature.";
    }

    private CoilsOfTheMedusaDestroyEffect(CoilsOfTheMedusaDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public CoilsOfTheMedusaDestroyEffect copy() {
        return new CoilsOfTheMedusaDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantedCreature;
        Permanent coils = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        List blockers = new ArrayList();
        if (coils != null && coils.getAttachedTo() != null && (enchantedCreature = game.getPermanent(coils.getAttachedTo())) != null && enchantedCreature.isBlocked(game)) {
            for (CombatGroup group : game.getCombat().getGroups()) {
                if (!group.getAttackers().contains(enchantedCreature.getId())) continue;
                blockers = group.getBlockers();
                break;
            }
            while (!blockers.isEmpty()) {
                Permanent blocker = game.getPermanent((UUID)blockers.remove(0));
                if (blocker.hasAbility((Ability)DefenderAbility.getInstance(), game)) continue;
                blocker.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

