/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class ColdSnapDamageTargetEffect
extends OneShotEffect {
    private static final FilterLandPermanent filter = new FilterLandPermanent("snow lands");

    public ColdSnapDamageTargetEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to that player equal to the number of snow lands they control";
    }

    private ColdSnapDamageTargetEffect(ColdSnapDamageTargetEffect copy) {
        super((OneShotEffect)copy);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            int damage = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, this.getTargetPointer().getFirst(game, source), game).size();
            player.damage(damage, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public ColdSnapDamageTargetEffect copy() {
        return new ColdSnapDamageTargetEffect(this);
    }

    static {
        filter.add((Predicate)SuperType.SNOW.getPredicate());
    }
}

