/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.keyword.EscalateAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.c.CollectiveDefianceEffect;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.FilterPlayer;
import mage.filter.common.FilterCreaturePermanent;
import mage.target.TargetPermanent;
import mage.target.TargetPlayer;
import mage.target.common.TargetOpponentOrPlaneswalker;

public final class CollectiveDefiance
extends CardImpl {
    private static final FilterPlayer filterDiscard = new FilterPlayer("player to discard and then draw cards");
    private static final FilterCreaturePermanent filterCreature = new FilterCreaturePermanent("creature to be dealt damage");

    public CollectiveDefiance(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{1}{R}{R}");
        this.addAbility((Ability)new EscalateAbility((Cost)new GenericManaCost(1)));
        this.getSpellAbility().getModes().setMinModes(1);
        this.getSpellAbility().getModes().setMaxModes(3);
        this.getSpellAbility().addEffect((Effect)new CollectiveDefianceEffect());
        this.getSpellAbility().addTarget(new TargetPlayer(1, 1, false, filterDiscard).withChooseHint("discards all cards and draws"));
        DamageTargetEffect effect = new DamageTargetEffect(4);
        effect.setText("{this} deals 4 damage to target creature");
        Mode mode = new Mode((Effect)effect);
        mode.addTarget(new TargetPermanent((FilterPermanent)filterCreature).withChooseHint("deals 4 damage to"));
        this.getSpellAbility().addMode(mode);
        effect = new DamageTargetEffect(3);
        effect.setText("{this} deals 3 damage to target opponent or planeswalker");
        mode = new Mode((Effect)effect);
        mode.addTarget(new TargetOpponentOrPlaneswalker().withChooseHint("deals 3 damage to"));
        this.getSpellAbility().addMode(mode);
    }

    private CollectiveDefiance(CollectiveDefiance card) {
        super((CardImpl)card);
    }

    public CollectiveDefiance copy() {
        return new CollectiveDefiance(this);
    }
}

