/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CollectiveDefianceEffect
extends OneShotEffect {
    CollectiveDefianceEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player discards all the cards in their hand, then draws that many cards";
    }

    private CollectiveDefianceEffect(CollectiveDefianceEffect effect) {
        super((OneShotEffect)effect);
    }

    public CollectiveDefianceEffect copy() {
        return new CollectiveDefianceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return false;
        }
        int count = targetPlayer.discard(targetPlayer.getHand(), false, source, game).size();
        targetPlayer.drawCards(count, source, game);
        return true;
    }
}

