/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.c.ColossalGraveReaverEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeBatchEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class ColossalGraveReaverTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<ZoneChangeEvent> {
    ColossalGraveReaverTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ColossalGraveReaverEffect());
    }

    private ColossalGraveReaverTriggeredAbility(ColossalGraveReaverTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ColossalGraveReaverTriggeredAbility copy() {
        return new ColossalGraveReaverTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_BATCH;
    }

    public boolean checkEvent(ZoneChangeEvent event, Game game) {
        if (event.getFromZone() != Zone.LIBRARY || event.getToZone() != Zone.GRAVEYARD) {
            return false;
        }
        Card card = game.getCard(event.getTargetId());
        return card != null && card.isCreature(game) && card.isOwnedBy(this.getControllerId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Set set = this.getFilteredEvents((BatchEvent)((ZoneChangeBatchEvent)event), game).stream().map(GameEvent::getTargetId).map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set.isEmpty()) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTargets(set, game));
        return true;
    }

    public String getRule() {
        return "Whenever one or more creature cards are put into your graveyard from your library, put one of them onto the battlefield.";
    }
}

