/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.condition.common.KickedCondition;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ColossalGrowthEffect
extends OneShotEffect {
    ColossalGrowthEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Target creature gets +3/+3 until end of turn. If this spell was kicked, instead that creature gets +4/+4 and gains trample and haste until end of turn.";
    }

    private ColossalGrowthEffect(ColossalGrowthEffect effect) {
        super((OneShotEffect)effect);
    }

    public ColossalGrowthEffect copy() {
        return new ColossalGrowthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (KickedCondition.ONCE.apply(game, source)) {
            game.addEffect(new BoostTargetEffect(4, 4).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
            game.addEffect(new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
            game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        } else {
            game.addEffect(new BoostTargetEffect(3, 3).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

