/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.c.CombustibleGearhulkMillAndDamageEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CombustibleGearhulkEffect
extends OneShotEffect {
    CombustibleGearhulkEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "target opponent may have you draw three cards. If the player doesn't, you mill three cards, then {this} deals damage to that player equal to the total mana value of those cards";
    }

    private CombustibleGearhulkEffect(CombustibleGearhulkEffect effect) {
        super((OneShotEffect)effect);
    }

    public CombustibleGearhulkEffect copy() {
        return new CombustibleGearhulkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null && (opponent = game.getPlayer(source.getFirstTarget())) != null) {
            String questionDrawThree = "Have " + controller.getLogName() + " draw three cards?";
            if (opponent.chooseUse(this.outcome, questionDrawThree, source, game)) {
                if (!game.isSimulation()) {
                    game.informPlayers(opponent.getLogName() + " lets " + controller.getLogName() + " draw three cards");
                }
                return new DrawCardSourceControllerEffect(3).apply(game, source);
            }
            if (!game.isSimulation()) {
                game.informPlayers(opponent.getLogName() + " does not let " + controller.getLogName() + " draw three cards");
            }
            return new CombustibleGearhulkMillAndDamageEffect().apply(game, source);
        }
        return false;
    }
}

