/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CountersSourceCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.cards.c.CometStellarPupContinuousEffect;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SquirrelToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetCreatureOrPlayer;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class CometStellarPupAbility
extends OneShotEffect {
    private static final FilterCard filterCard = new FilterCard("card with mana value 2 or less from your graveyard");

    CometStellarPupAbility() {
        super(Outcome.Benefit);
        this.staticText = "Roll a six-sided die.<br>1 or 2 &mdash; [+2], then create two 1/1 green Squirrel creature tokens. They gain haste until end of turn.<br>3 &mdash; [-1], then return a card with mana value 2 or less from your graveyard to your hand.<br>4 or 5 &mdash; {this} deals damage equal to the number of loyalty counters on him to a creature or player, then [-2].<br>6 &mdash; [+1], and you may activate {this}'s loyalty ability two more times this turn.";
    }

    private CometStellarPupAbility(CometStellarPupAbility effect) {
        super((OneShotEffect)effect);
    }

    public CometStellarPupAbility copy() {
        return new CometStellarPupAbility(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 6);
        if (result == 1 || result == 2) {
            new AddCountersSourceEffect(CounterType.LOYALTY.createInstance(2)).apply(game, source);
            SquirrelToken token = new SquirrelToken();
            token.putOntoBattlefield(2, game, source);
            game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)), source);
        } else if (result == 3) {
            new RemoveCounterSourceEffect(CounterType.LOYALTY.createInstance(1)).apply(game, source);
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filterCard);
            target.withNotTarget(true);
            if (!target.canChoose(source.getControllerId(), source, game)) {
                return true;
            }
            player.choose(this.outcome, (Target)target, source, game);
            Card card = game.getCard(target.getFirstTarget());
            if (card != null) {
                player.moveCards(card, Zone.HAND, source, game);
            }
        } else if (result == 4 || result == 5) {
            TargetCreatureOrPlayer target = new TargetCreatureOrPlayer();
            target.withNotTarget(true);
            if (!target.canChoose(source.getControllerId(), source, game)) {
                return true;
            }
            player.choose(Outcome.Damage, (Target)target, source, game);
            new DamageTargetEffect((DynamicValue)new CountersSourceCount(CounterType.LOYALTY)).setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget())).apply(game, source);
            new RemoveCounterSourceEffect(CounterType.LOYALTY.createInstance(2)).apply(game, source);
        } else if (result == 6) {
            new AddCountersSourceEffect(CounterType.LOYALTY.createInstance(1)).apply(game, source);
            Permanent comet = source.getSourcePermanentIfItStillExists(game);
            if (comet != null) {
                game.addEffect((ContinuousEffect)new CometStellarPupContinuousEffect(new MageObjectReference((MageObject)comet, game)), source);
            }
        }
        return true;
    }

    static {
        filterCard.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, 2));
    }
}

