/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class CommandTheDreadhordeEffect
extends OneShotEffect {
    CommandTheDreadhordeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose any number of target creature and/or planeswalker cards in graveyards. {this} deals damage to you equal to the total mana value of those cards. Put them onto the battlefield under your control.";
    }

    private CommandTheDreadhordeEffect(CommandTheDreadhordeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CommandTheDreadhordeEffect copy() {
        return new CommandTheDreadhordeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)((Target)source.getTargets().get(0)).getTargets());
        int damage = cards.getCards(game).stream().mapToInt(MageObject::getManaValue).sum();
        player.damage(damage, source.getSourceId(), source, game);
        return player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
    }
}

