/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class CommanderLiaraPortyrExileEffect
extends OneShotEffect {
    CommanderLiaraPortyrExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top X cards of your library. Until end of turn, you may cast spells from among those exiled cards";
    }

    private CommanderLiaraPortyrExileEffect(CommanderLiaraPortyrExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public CommanderLiaraPortyrExileEffect copy() {
        return new CommanderLiaraPortyrExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int count = Optional.ofNullable((Integer)this.getValue("number_defending_players")).orElse(0);
        if (player == null || count < 1) {
            return true;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, count));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)false);
        }
        return true;
    }
}

