/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CommunalBrewingEffect
extends OneShotEffect {
    CommunalBrewingEffect() {
        super(Outcome.Benefit);
        this.staticText = "any number of target opponents each draw a card. Put an ingredient counter on {this}, then put an ingredient counter on it for each card drawn this way";
    }

    private CommunalBrewingEffect(CommunalBrewingEffect effect) {
        super((OneShotEffect)effect);
    }

    public CommunalBrewingEffect copy() {
        return new CommunalBrewingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = 0;
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Player opponent = game.getPlayer(targetId);
            if (opponent == null) continue;
            count += opponent.drawCards(1, source, game);
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        return permanent.addCounters(CounterType.INGREDIENT.createInstance(count + 1), source, game);
    }
}

